<?php
/*
  Author: Greg Feigenson
  File: open_workorders.php
  Copyright: 2004-2005 Greg Feigenson
  
  This software is licensed under the BSD license.
  Please see attached license or www.opensource.org
  for details
*/
require_once("objects/workorder_object.php");
require('includes/header.inc.php');
	
//container class for workorders
$workorders = array();
$problem = "";
$workordersWithProblems = array();

/* Print header */
echo "<DIV align='center'> <H1>Trouble Tickets:</H1>";

/* Connecting, selecting database */
require("includes/db.inc.php");

if (isset($_POST['submitted']) /*== "yes"*/)
{
	$status = $_POST['select'];
	$id = $_POST['wo_id'];
	$query = "UPDATE workorder SET status=$status WHERE workorder_id=$id";
	$result = pg_exec($query);
}

/* Performing SQL query */
$query = "SELECT * FROM public.workorder_cust";
$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));
   
/* Printing results in HTML */
echo " <table padding=1 border=1><tr>
	   <td> Workorder ID (mouse over)  </td>
	   <td> Date Due                   </td>
	   <td> Customer                   </td>
	   <td> Phone1                     </td>
	   <td> Phone2                     </td>
	   <td> Assigned to                </td>
	   <td> Status (mouse over)        </td>
	   <td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td> <!-- hack for Z-Layer bug -->
	   <td> New Status                 </td>
	   </tr><tr></tr><tr></tr>";

while ($line = pg_fetch_assoc($result)) {
		$db_workorder = new workorder($line['start_date'],$line['promised_date'], $line['first_name'], $line['last_name'],$line['phone1'], $line['phone2'], $line['workorder_id']);                   
		$db_workorder->setStaff($line['staff']);
		$db_workorder->setStatus($line['status']);
		array_push($workorders,$db_workorder);  //build array of workorders
}
    
/* associate problems with work orders */
foreach($workorders as $workorder)
{
	$id = $workorder->id;
	$query = "SELECT problem.description, problem.notes, problem.estimated_time FROM problem WHERE problem.work_order_id = $id";
	$result = pg_query($connection,$query) or die("Query failed : " . pg_last_error($connection));

	while ($line = pg_fetch_assoc($result)) {
		  $problem .= "Problem: "       .$line['description']   ."<br> ";
		  $problem .= "Notes: "         .$line['notes']         ."<br> ";
		  $problem .= "Estimated Time: ".$line['estimated_time']." hours<br><br><br>";
	}
	
	$workorder->problems = $problem;//add the problem
	array_push($workordersWithProblems,$workorder);   //since the foreach doesn't allow editing of data...
	$problem = ""; //empty the problem
}
    
/* Associate notes with work orders */
foreach($workorders as $workorder)
{
		$id = $workorder->id;
		$query = "SELECT note.date, note.author, note.text FROM note WHERE note.work_order_id = $id";
		$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection)); 
		
		while ($line = pg_fetch_assoc($result)) {
		  $note .= "Author: "       .$line['author']   ."<br> ";
		  $note .= "Date: "         .$line['date']     ."<br> ";
		  $note .= "Note: "         .$line['text']     ."<br><br><br>";
	}
	
	$workorder->notes = $note;//add the problem
	$note= ""; //empty the note
}

unset($workorders); //free up space used by temporary array
   
foreach($workordersWithProblems as $workorder)
{
		 echo "<tr><td><a href='#' class='info'>".$workorder->id."<span>".$workorder->problems."</span></a></td>";
		 
	 if (strtotime($workorder->due_date) <= time())
						echo "<td><b><font color='red'>(PAST DUE) ".date("d/m/Y h:ia",strtotime($workorder->due_date))."<b></td>";
	 else
			echo "<td>".date("m/d/Y h:ia",strtotime($workorder->due_date))."</td>";
			
	 echo "<td>".$workorder->first_name." ".$workorder->last_name."</td>";
	 echo "<td>".$workorder->phone1."</td>";
	 echo "<td>".$workorder->phone2."</td>";   
	 echo "<td>".$workorder->staff."</td>";
	 echo "<td><a href='#' class='info'>".$workorder->checkStatus($workorder->status)."<span>".$workorder->notes."</span></a></td>";
		 
		 /* Form for changing status */
		 echo "<td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td><td>";
		 echo "<td>
						<form name='form' action='open_workorders.php' method='POST'>
						<input type='hidden' name='submitted' value='yes'>
						<input type='hidden' name='wo_id' value='".$workorder->id."'>
								<select name='select' onChange='submit()'>
									  <option value='0'></option>
									<option value='0'>Open</option>
									<option value='1'>Closed</option>
									<option value='2'>On Hold</option>
								 </select>
					  </form></td>";
}
        
   print "</table>\n";

   /* Closing connection */
   pg_close($connection);
   
require('includes/footer.inc.php');
?>