/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef BASELISTVIEWITEM_H
#define BASELISTVIEWITEM_H

#include <qlistview.h>
#include <qpopupmenu.h>

/**
 * Base class that all list view item classes are to inherit.
 */
class BaseListViewItem: public QListViewItem
{
protected:	
	QString m_qstrDescription;	
	bool m_bLeaf;
	bool m_bExpanded;
	QPopupMenu * m_pqoPopupMenu;
			
public:
	
	/**
 	 * Constructors, based on QListViewItem constructors.
   */		
	BaseListViewItem(QListView *pqoListView);
	BaseListViewItem(QListView *pqoListView, QListViewItem *pqoAfterItem);
	BaseListViewItem(QListViewItem *pqoListViewItem);
	BaseListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);

	/**
	 * Destructor
	 */
	virtual ~BaseListViewItem();
	
	/**
	 * Used to update the description for this live view item.
	 */
	virtual void updateDescription();
	
	/**
 	 * Used to return a description of this item.
   */			    							
	const QString & getDescription();

	/**
 	 * Used to set a description of this item.
   */			    							
	void setDescription(const QString & rstrDescription);
			
	/**
 	 * Used to set the expanded flag.
 	 * @param boolean to indicate if this list view item has been expanded before
   */			    							
	void setExpanded(bool bExpanded);
	
	/**
 	 * Used to find out if this item has been expanded before.
 	 * @return	true if this item has been expanded before, false otherwise
   */			    							
	bool hasExpanded();
			
	/**
 	 * Used to find out if this item is a leaf item.
 	 * @return	true if this item is a leaf, false otherwise
   */			    							
	bool isLeaf();

	/**
 	 * Used to set if this item is a leaf.
 	 * @param	bLeaf	indicates if this item is a leaf or not
   */			    							
	void setLeaf(bool bLeaf);

	/**
 	 * Used to delete all the children of this item.
   */			    						
	virtual void deleteChildren();
	
	/**
 	 * Used to traverse all children and warn them to prepare their own children.
 	 * The base has a generic implementation. This should work for most situations.
   */			    						
	virtual void initGrandChildren();
			
	/**
 	 * Used to refresh itself and its children.
   */			    			
	virtual void refreshList();

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
	
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	virtual void initChildren();
					
public slots:



private:
	/**
	 * Used to initialise variables for all constructors.
	 */
	void initObject();
};


#endif

